<?php
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';

public_header(t('nav.services'));
?>
<h1 class="text-3xl font-bold tracking-tight"><?= htmlspecialchars(t('services.title')) ?></h1>
<p class="mt-3 text-slate-600 leading-7"><?= htmlspecialchars(t('services.desc')) ?></p>

<div class="mt-8 grid grid-cols-1 md:grid-cols-2 gap-4">
    <div class="rounded-2xl border border-slate-200 bg-white p-6">
        <h2 class="text-lg font-bold"><?= htmlspecialchars(t('services.fm')) ?></h2>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('services.fm_desc')) ?></p>
    </div>
    <div class="rounded-2xl border border-slate-200 bg-white p-6">
        <h2 class="text-lg font-bold"><?= htmlspecialchars(t('services.bp')) ?></h2>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('services.bp_desc')) ?></p>
    </div>
    <div class="rounded-2xl border border-slate-200 bg-white p-6">
        <h2 class="text-lg font-bold"><?= htmlspecialchars(t('services.fr')) ?></h2>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('services.fr_desc')) ?></p>
    </div>
    <div class="rounded-2xl border border-slate-200 bg-white p-6">
        <h2 class="text-lg font-bold"><?= htmlspecialchars(t('services.pm')) ?></h2>
        <p class="mt-2 text-sm text-slate-600 leading-6"><?= htmlspecialchars(t('services.pm_desc')) ?></p>
    </div>
</div>

<div class="mt-8 rounded-2xl border border-slate-200 bg-slate-900 p-6 text-white">
    <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">
        <div>
            <div class="text-sm font-semibold text-white/80"><?= htmlspecialchars(t('services.ready')) ?></div>
            <div class="mt-1 text-xl font-bold"><?= htmlspecialchars(t('services.cta')) ?></div>
        </div>
        <a href="/nyakinama/login.php" class="inline-flex items-center justify-center rounded-xl bg-white px-5 py-3 text-sm font-semibold text-slate-900 hover:bg-slate-100"><?= htmlspecialchars(t('nav.login')) ?></a>
    </div>
</div>
<?php
public_footer();
