<?php

function toast_start_session(): void {
    if (session_status() !== PHP_SESSION_ACTIVE) {
        session_start();
    }
}

function toast_set(string $type, string $message): void {
    toast_start_session();
    $_SESSION['toast'] = [
        'type' => $type,
        'message' => $message,
    ];
}

function toast_pop(): ?array {
    toast_start_session();
    if (!isset($_SESSION['toast']) || !is_array($_SESSION['toast'])) {
        return null;
    }

    $toast = $_SESSION['toast'];
    unset($_SESSION['toast']);
    return $toast;
}

function toast_render(): void {
    $toast = toast_pop();
    if (!$toast) {
        return;
    }

    $type = (string)($toast['type'] ?? 'info');
    $message = (string)($toast['message'] ?? '');

    $styles = [
        'success' => 'border-emerald-200 bg-emerald-50 text-emerald-900',
        'error' => 'border-red-200 bg-red-50 text-red-900',
        'info' => 'border-sky-200 bg-sky-50 text-sky-900',
        'warning' => 'border-amber-200 bg-amber-50 text-amber-900',
    ];

    $style = $styles[$type] ?? $styles['info'];

    ?>
    <div id="toast" class="fixed right-4 bottom-4 z-[100] w-[calc(100%-2rem)] max-w-sm">
        <div class="rounded-2xl border <?= htmlspecialchars($style) ?> shadow-lg shadow-slate-900/10">
            <div class="flex items-start gap-3 p-4">
                <div class="flex-1">
                    <div class="text-sm font-semibold"><?= htmlspecialchars(ucfirst($type)) ?></div>
                    <div class="mt-1 text-sm leading-6"><?= htmlspecialchars($message) ?></div>
                </div>
                <button type="button" class="rounded-xl border border-slate-200 bg-white/70 px-2 py-1 text-xs font-semibold text-slate-700 hover:bg-white" onclick="document.getElementById('toast')?.remove()">Close</button>
            </div>
        </div>
    </div>
    <script>
        (function () {
            var el = document.getElementById('toast');
            if (!el) return;
            setTimeout(function () {
                if (!el) return;
                el.style.transition = 'opacity 200ms ease, transform 200ms ease';
                el.style.opacity = '0';
                el.style.transform = 'translateY(-6px)';
                setTimeout(function () { el && el.remove(); }, 250);
            }, 3200);
        })();
    </script>
    <?php
}
