<?php
require_once __DIR__ . '/tailwind.php';
require_once __DIR__ . '/toast.php';
require_once __DIR__ . '/i18n.php';

function public_header(string $title): void {
    ?><!doctype html>
    <html lang="en">
    <head>
        <meta charset="utf-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1" />
        <title><?= htmlspecialchars($title) ?> - Nyakinama Management</title>
        <?php tailwind_cdn(); ?>
    </head>
    <body class="min-h-screen bg-gradient-to-b from-slate-50 to-white text-slate-900">
        <?php toast_render(); ?>
        <header class="bg-white/90 backdrop-blur border-b border-slate-200 sticky top-0 z-40">
            <div class="max-w-6xl mx-auto px-4 py-4 flex items-center justify-between">
                <a href="/nyakinama/index.php" class="font-semibold tracking-tight text-slate-900">
                    NYAKINAMA MANAGEMENT
                </a>

                <nav class="hidden md:flex items-center gap-6 text-sm font-medium text-slate-700">
                    <a class="hover:text-slate-900" href="/nyakinama/index.php"><?= htmlspecialchars(t('nav.home')) ?></a>
                    <a class="hover:text-slate-900" href="/nyakinama/about.php"><?= htmlspecialchars(t('nav.about')) ?></a>
                    <a class="hover:text-slate-900" href="/nyakinama/services.php"><?= htmlspecialchars(t('nav.services')) ?></a>
                    <a class="hover:text-slate-900" href="/nyakinama/news.php"><?= htmlspecialchars(t('nav.news')) ?></a>
                    <a class="hover:text-slate-900" href="/nyakinama/contact.php"><?= htmlspecialchars(t('nav.contact')) ?></a>
                </nav>

                <div class="flex items-center gap-3">
                    <a href="/nyakinama/login.php" class="inline-flex items-center justify-center rounded-xl bg-gradient-to-r from-slate-900 to-indigo-900 px-4 py-2 text-sm font-semibold text-white shadow-sm shadow-slate-900/10 hover:from-slate-800 hover:to-indigo-800">
                        <?= htmlspecialchars(t('nav.login')) ?>
                    </a>
                </div>
            </div>
        </header>

        <main class="max-w-6xl mx-auto px-4 py-10">
<?php
}
