<?php

require_once __DIR__ . '/settings_store.php';

function auth_start_session(): void {
    if (session_status() !== PHP_SESSION_ACTIVE) {
        session_start();
    }
}

function auth_is_logged_in(): bool {
    auth_start_session();
    return isset($_SESSION['auth_user']) && is_array($_SESSION['auth_user']);
}

function auth_login(string $email, string $password): bool {
    $email = trim($email);

    $settings = settings_get();
    $validEmail = (string)($settings['admin_email'] ?? '');
    $validHash = (string)($settings['admin_password_hash'] ?? '');

    if ($validEmail === '' || $validHash === '') {
        return false;
    }

    if (!hash_equals($validEmail, $email)) {
        return false;
    }

    if (!password_verify($password, $validHash)) {
        return false;
    }

    auth_start_session();
    $_SESSION['auth_user'] = [
        'email' => $validEmail,
        'role' => 'Admin',
    ];

    return true;
}

function auth_logout(): void {
    auth_start_session();
    $_SESSION = [];

    if (ini_get('session.use_cookies')) {
        $params = session_get_cookie_params();
        setcookie(session_name(), '', time() - 42000, $params['path'], $params['domain'], $params['secure'], $params['httponly']);
    }

    session_destroy();
}

function auth_require_login(): void {
    if (!auth_is_logged_in()) {
        header('Location: /nyakinama/login.php');
        exit;
    }
}
