<?php
require_once __DIR__ . '/includes/public_header.php';
require_once __DIR__ . '/includes/public_footer.php';

public_header(t('nav.contact'));
?>
<div class="grid grid-cols-1 lg:grid-cols-12 gap-8">
    <div class="lg:col-span-6">
        <h1 class="text-3xl font-bold tracking-tight"><?= htmlspecialchars(t('contact.title')) ?></h1>
        <p class="mt-3 text-slate-600 leading-7"><?= htmlspecialchars(t('contact.desc')) ?></p>

        <div class="mt-8 rounded-2xl border border-slate-200 bg-white p-6">
            <div class="grid grid-cols-1 sm:grid-cols-2 gap-4 text-sm">
                <div>
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('contact.address')) ?></div>
                    <div class="mt-1 font-semibold text-slate-900"><?= htmlspecialchars(t('contact.diocese_parish')) ?></div>
                    <div class="mt-1 text-slate-600">Nyakinama</div>
                </div>
                <div>
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('contact.phone_email')) ?></div>
                    <div class="mt-1 text-slate-600">Phone: —</div>
                    <div class="mt-1 text-slate-600">Email: —</div>
                </div>
            </div>
        </div>
    </div>

    <div class="lg:col-span-6">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="text-sm font-semibold text-slate-900"><?= htmlspecialchars(t('contact.send_message')) ?></div>
            <form class="mt-4 space-y-4" method="post" action="#">
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('contact.full_name')) ?></label>
                    <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm outline-none focus:ring-2 focus:ring-slate-900/20" type="text" name="name" placeholder="<?= htmlspecialchars(t('contact.your_name')) ?>" />
                </div>
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('login.email')) ?></label>
                    <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm outline-none focus:ring-2 focus:ring-slate-900/20" type="email" name="email" placeholder="<?= htmlspecialchars(t('contact.your_email')) ?>" />
                </div>
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('contact.message')) ?></label>
                    <textarea class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm outline-none focus:ring-2 focus:ring-slate-900/20" name="message" rows="5" placeholder="<?= htmlspecialchars(t('contact.write_message')) ?>"></textarea>
                </div>
                <button class="w-full rounded-xl bg-slate-900 px-4 py-3 text-sm font-semibold text-white hover:bg-slate-800" type="submit"><?= htmlspecialchars(t('contact.send')) ?></button>
            </form>
        </div>
    </div>
</div>
<?php
public_footer();
