<?php
require_once __DIR__ . '/includes/admin_layout.php';

admin_header(t('reports.title'));
$year = $_GET['year'] ?? '2024-2025';
?>
<div class="grid grid-cols-1 xl:grid-cols-12 gap-6">
    <section class="xl:col-span-12">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold"><?= htmlspecialchars(t('reports.center')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.year')) ?>: <?= htmlspecialchars($year) ?></div>
                </div>
                <div class="flex flex-wrap gap-2">
                    <button class="rounded-xl bg-slate-900 px-4 py-2 text-sm font-semibold text-white hover:bg-slate-800" type="button"><?= htmlspecialchars(t('reports.export_pdf')) ?></button>
                    <button class="rounded-xl border border-slate-300 bg-white px-4 py-2 text-sm font-semibold hover:bg-slate-50" type="button"><?= htmlspecialchars(t('reports.export_excel')) ?></button>
                </div>
            </div>
        </div>

        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="text-sm font-semibold">PAROISSE DE NYAKINAMA</div>
            <div class="mt-1 text-xs text-slate-500">SYNTHESE DE L’ETAT BUDGETAIRE : ANNEE PASTORALE <?= htmlspecialchars($year) ?></div>

            <div class="mt-6 text-sm font-semibold">I. SYNTHESE DES RECETTES</div>
            <div class="mt-3 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-xs font-semibold text-slate-500">
                            <th class="py-2 pr-4">&nbsp;</th>
                            <th class="py-2 pr-4">Prévisions</th>
                            <th class="py-2 pr-4">Réalisations</th>
                            <th class="py-2 pr-4">Écart</th>
                            <th class="py-2 pr-4">% de Réalisation</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200">
                        <tr>
                            <td class="py-2 pr-4 font-semibold">A. Report de l’Exercice precedent (A1)</td>
                            <td class="py-2 pr-4">971,213</td>
                            <td class="py-2 pr-4">971,213</td>
                            <td class="py-2 pr-4">-</td>
                            <td class="py-2 pr-4">-</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4 font-semibold">RECETTES INTERNES</td>
                            <td class="py-2 pr-4">&nbsp;</td>
                            <td class="py-2 pr-4">&nbsp;</td>
                            <td class="py-2 pr-4">&nbsp;</td>
                            <td class="py-2 pr-4">&nbsp;</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4">Recettes Propres</td>
                            <td class="py-2 pr-4">22,400,000</td>
                            <td class="py-2 pr-4">22,631,855</td>
                            <td class="py-2 pr-4">-231,855</td>
                            <td class="py-2 pr-4">101</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4">Autres Recettes</td>
                            <td class="py-2 pr-4">3,874,000</td>
                            <td class="py-2 pr-4">5,311,420</td>
                            <td class="py-2 pr-4">-1,437,420</td>
                            <td class="py-2 pr-4">137</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4">Recettes des activités génératrices de revenu</td>
                            <td class="py-2 pr-4">9,860,000</td>
                            <td class="py-2 pr-4">7,183,937</td>
                            <td class="py-2 pr-4">2,676,063</td>
                            <td class="py-2 pr-4">73</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4">Recettes pour tiers partenaires</td>
                            <td class="py-2 pr-4">5,050,000</td>
                            <td class="py-2 pr-4">3,759,245</td>
                            <td class="py-2 pr-4">1,290,755</td>
                            <td class="py-2 pr-4">74</td>
                        </tr>
                        <tr class="bg-slate-50">
                            <td class="py-2 pr-4 font-semibold">Total (B1)</td>
                            <td class="py-2 pr-4 font-semibold">41,184,000</td>
                            <td class="py-2 pr-4 font-semibold">38,886,457</td>
                            <td class="py-2 pr-4 font-semibold">2,297,543</td>
                            <td class="py-2 pr-4 font-semibold">94</td>
                        </tr>
                        <tr class="bg-amber-50">
                            <td class="py-2 pr-4 font-semibold">Total des Recettes (A1+B1)</td>
                            <td class="py-2 pr-4 font-semibold">42,155,213</td>
                            <td class="py-2 pr-4 font-semibold">39,857,670</td>
                            <td class="py-2 pr-4 font-semibold">2,297,543</td>
                            <td class="py-2 pr-4 font-semibold">95</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="mt-8 text-sm font-semibold">II. SYNTHESE DES DEPENSES</div>
            <div class="mt-3 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-xs font-semibold text-slate-500">
                            <th class="py-2 pr-4">&nbsp;</th>
                            <th class="py-2 pr-4">Prévisions</th>
                            <th class="py-2 pr-4">Réalisations</th>
                            <th class="py-2 pr-4">Écart</th>
                            <th class="py-2 pr-4">% de Réalisation</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200">
                        <tr>
                            <td class="py-2 pr-4 font-semibold">A. DEPENSES ORDINAIRES</td>
                            <td class="py-2 pr-4">39,587,213</td>
                            <td class="py-2 pr-4">38,057,234</td>
                            <td class="py-2 pr-4">1,529,979</td>
                            <td class="py-2 pr-4">96</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4 font-semibold">B. DEPENSES D’INVESTISSEMENT</td>
                            <td class="py-2 pr-4">400,000</td>
                            <td class="py-2 pr-4">-</td>
                            <td class="py-2 pr-4">400,000</td>
                            <td class="py-2 pr-4">-</td>
                        </tr>
                        <tr>
                            <td class="py-2 pr-4 font-semibold">C. DEPENSE POUR TIERS PARTENAIRES</td>
                            <td class="py-2 pr-4">2,168,000</td>
                            <td class="py-2 pr-4">1,110,705</td>
                            <td class="py-2 pr-4">1,057,295</td>
                            <td class="py-2 pr-4">51</td>
                        </tr>
                        <tr class="bg-amber-50">
                            <td class="py-2 pr-4 font-semibold">Total des Dépenses (A2 + B2 + C2)</td>
                            <td class="py-2 pr-4 font-semibold">42,155,213</td>
                            <td class="py-2 pr-4 font-semibold">39,167,939</td>
                            <td class="py-2 pr-4 font-semibold">2,987,274</td>
                            <td class="py-2 pr-4 font-semibold">93</td>
                        </tr>
                    </tbody>
                </table>
            </div>

            <div class="mt-4 rounded-2xl border border-emerald-200 bg-emerald-50 p-4">
                <div class="text-sm font-semibold">RESULTAT (A1+B1 - A2+B2+C2)</div>
                <div class="mt-2 text-2xl font-bold text-emerald-800">689,731</div>
            </div>

            <div class="mt-8 grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-5">
                    <div class="text-sm font-semibold">SITUATION DE TRESORERIE</div>
                    <div class="mt-3 overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead>
                                <tr class="text-left text-xs font-semibold text-slate-500">
                                    <th class="py-2 pr-4">&nbsp;</th>
                                    <th class="py-2 pr-4">Montant</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-200">
                                <tr>
                                    <td class="py-2 pr-4 font-semibold">CAISSE</td>
                                    <td class="py-2 pr-4">177,455</td>
                                </tr>
                                <tr>
                                    <td class="py-2 pr-4 font-semibold" colspan="2">BANQUES</td>
                                </tr>
                                <tr><td class="py-2 pr-4">1. BPR KRISTU MWAMI NYAKINAMA</td><td class="py-2 pr-4">173,254</td></tr>
                                <tr><td class="py-2 pr-4">2. BPR PARUWASI GATALIKA NYAKINAMA</td><td class="py-2 pr-4">39,689</td></tr>
                                <tr><td class="py-2 pr-4">3. BPR C F DE COUP COUTURE NYAKINAMA</td><td class="py-2 pr-4">184,460</td></tr>
                                <tr><td class="py-2 pr-4">4. IGIHONDOHONDO SACCO</td><td class="py-2 pr-4">53,665</td></tr>
                                <tr><td class="py-2 pr-4">5. RUGERA SACCO</td><td class="py-2 pr-4">51,879</td></tr>
                                <tr><td class="py-2 pr-4">6. INYUBAKO KARAMBO RUGERA SACCO</td><td class="py-2 pr-4">9,329</td></tr>
                                <tr class="bg-white">
                                    <td class="py-2 pr-4 font-semibold">TOTAL BANQUES</td>
                                    <td class="py-2 pr-4 font-semibold">512,276</td>
                                </tr>
                                <tr class="bg-white">
                                    <td class="py-2 pr-4 font-semibold">TOTAL BANQUES + CAISSE</td>
                                    <td class="py-2 pr-4 font-semibold">689,731</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-5">
                    <div class="text-sm font-semibold">SITUATION DES CREANCES</div>
                    <div class="mt-3 overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead>
                                <tr class="text-left text-xs font-semibold text-slate-500">
                                    <th class="py-2 pr-4">Noms</th>
                                    <th class="py-2 pr-4">Montant</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-200">
                                <tr><td class="py-2 pr-4">ABAKOZI BA PARUWASI</td><td class="py-2 pr-4">346,000</td></tr>
                                <tr><td class="py-2 pr-4">Korali Intumwanza</td><td class="py-2 pr-4">100,000</td></tr>
                                <tr><td class="py-2 pr-4">HAKIZIMANA (Imyaka)</td><td class="py-2 pr-4">922,200</td></tr>
                                <tr class="bg-white">
                                    <td class="py-2 pr-4 font-semibold">TOTAL DES CREANCES</td>
                                    <td class="py-2 pr-4 font-semibold">1,368,200</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-5">
                    <div class="text-sm font-semibold">SITUATION DES DETTES</div>
                    <div class="mt-3 overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead>
                                <tr class="text-left text-xs font-semibold text-slate-500">
                                    <th class="py-2 pr-4">Noms</th>
                                    <th class="py-2 pr-4">Montant</th>
                                </tr>
                            </thead>
                            <tbody class="divide-y divide-slate-200">
                                <tr><td class="py-2 pr-4">KUBIKIRA AMATSINDA N’AMAHURIRO</td><td class="py-2 pr-4">2,212,170</td></tr>
                                <tr><td class="py-2 pr-4">HITIMANA Emmanuel (Sima)</td><td class="py-2 pr-4">837,000</td></tr>
                                <tr><td class="py-2 pr-4">RUGIMBANA Anaclet</td><td class="py-2 pr-4">720,000</td></tr>
                                <tr><td class="py-2 pr-4">ZABAYO</td><td class="py-2 pr-4">173,500</td></tr>
                                <tr><td class="py-2 pr-4">CARITAS (Diocèse)</td><td class="py-2 pr-4">691,650</td></tr>
                                <tr class="bg-white">
                                    <td class="py-2 pr-4 font-semibold">TOTAL DES DETTES</td>
                                    <td class="py-2 pr-4 font-semibold">4,634,320</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<?php
admin_footer();
