<?php
require_once __DIR__ . '/includes/admin_layout.php';

admin_header(t('receipts.title'));
$year = $_GET['year'] ?? '2024-2025';
?>
<div class="flex flex-col lg:flex-row gap-6">
    <section class="flex-1">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold"><?= htmlspecialchars(t('receipts.add')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.year')) ?>: <?= htmlspecialchars($year) ?></div>
                </div>
                <button class="rounded-xl bg-slate-900 px-4 py-2 text-sm font-semibold text-white hover:bg-slate-800" type="button"><?= htmlspecialchars(t('common.save')) ?></button>
            </div>

            <form class="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4" method="post" action="#">
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('common.category')) ?></label>
                    <select class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" name="category">
                        <option><?= htmlspecialchars(t('cat.recettes_propres')) ?></option>
                        <option><?= htmlspecialchars(t('cat.offrandes')) ?></option>
                        <option><?= htmlspecialchars(t('cat.dons')) ?></option>
                        <option><?= htmlspecialchars(t('cat.subventions')) ?></option>
                        <option><?= htmlspecialchars(t('cat.other_income')) ?></option>
                    </select>
                </div>
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('common.date')) ?></label>
                    <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" type="date" name="date" />
                </div>
                <div class="md:col-span-2">
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('common.description')) ?></label>
                    <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" type="text" name="description" placeholder="<?= htmlspecialchars(t('receipts.details_placeholder')) ?>" />
                </div>
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('common.amount')) ?></label>
                    <input class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" type="number" name="amount" placeholder="0" />
                </div>
                <div>
                    <label class="block text-xs font-semibold text-slate-600"><?= htmlspecialchars(t('common.month')) ?></label>
                    <select class="mt-1 w-full rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" name="month">
                        <?php foreach (range(1, 12) as $m): ?>
                            <option value="<?= $m ?>"><?= $m ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </form>
        </div>

        <div class="mt-6 rounded-3xl border border-slate-200 bg-white p-6">
            <div class="flex items-center justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold"><?= htmlspecialchars(t('receipts.list')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('receipts.placeholder_table')) ?></div>
                </div>
                <div class="flex items-center gap-2">
                    <input class="w-56 rounded-xl border border-slate-300 bg-white px-3 py-2 text-sm" placeholder="<?= htmlspecialchars(t('common.search')) ?>" />
                    <button class="rounded-xl border border-slate-300 bg-white px-4 py-2 text-sm font-semibold hover:bg-slate-50" type="button"><?= htmlspecialchars(t('common.filter')) ?></button>
                </div>
            </div>

            <div class="mt-4 overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead>
                        <tr class="text-left text-xs font-semibold text-slate-500">
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.date')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.category')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.description')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.amount')) ?></th>
                            <th class="py-2 pr-4"><?= htmlspecialchars(t('common.actions')) ?></th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-slate-200">
                        <tr>
                            <td class="py-3 pr-4 text-slate-600">—</td>
                            <td class="py-3 pr-4">—</td>
                            <td class="py-3 pr-4 text-slate-600">—</td>
                            <td class="py-3 pr-4 font-semibold">—</td>
                            <td class="py-3 pr-4">
                                <div class="flex gap-2">
                                    <button class="rounded-lg border border-slate-300 bg-white px-3 py-1 text-xs font-semibold hover:bg-slate-50" type="button"><?= htmlspecialchars(t('common.edit')) ?></button>
                                    <button class="rounded-lg border border-slate-300 bg-white px-3 py-1 text-xs font-semibold hover:bg-slate-50" type="button"><?= htmlspecialchars(t('common.delete')) ?></button>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </section>

    <aside class="lg:w-96">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="text-sm font-semibold"><?= htmlspecialchars(t('receipts.summary')) ?></div>
            <div class="mt-4 grid grid-cols-1 gap-3 text-sm">
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('receipts.monthly_summary')) ?></div>
                    <div class="mt-1 text-slate-600"><?= htmlspecialchars(t('receipts.placeholder_chart')) ?></div>
                </div>
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('receipts.planned_vs_actual')) ?></div>
                    <div class="mt-1 text-slate-600">Prévisions vs Réalisations</div>
                </div>
            </div>
        </div>
    </aside>
</div>
<?php
admin_footer();
