<?php
require_once __DIR__ . '/includes/admin_layout.php';

admin_header(t('planning.title'));
$year = $_GET['year'] ?? '2024-2025';
?>

<?php if ((string)$year === '2025-2026'): ?>
    <div class="rounded-3xl border border-slate-200 bg-white p-6">
        <div class="flex items-start justify-between gap-4">
            <div>
                <div class="text-sm font-semibold text-slate-900"><?= htmlspecialchars(t('planning.card_financial_2025_2026')) ?></div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('planning.details_subtitle')) ?></div>
            </div>
            <a href="/nyakinama/admin/planning.php?year=<?= urlencode('2024-2025') ?>"
               class="inline-flex items-center rounded-xl border border-slate-200 bg-slate-50 px-4 py-2 text-sm font-semibold text-slate-900 hover:bg-white">
                <?= htmlspecialchars(t('planning.back')) ?>
            </a>
        </div>

        <div class="mt-6 rounded-2xl border border-slate-200 bg-slate-50 p-5">
            <div class="text-sm font-bold text-slate-900"><?= htmlspecialchars(t('planning.data_section_title')) ?></div>
            <div class="mt-2 text-sm leading-6 text-slate-600"><?= htmlspecialchars(t('planning.data_missing_note')) ?></div>
        </div>
    </div>
<?php else: ?>
    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <a href="/nyakinama/admin/planning.php?year=<?= urlencode('2025-2026') ?>"
           class="group rounded-3xl border border-slate-200 bg-white p-6 hover:border-slate-300 hover:shadow-sm hover:shadow-slate-900/5">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold text-slate-900"><?= htmlspecialchars(t('planning.card_financial_2025_2026')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('planning.card_financial_2025_2026_desc')) ?></div>
                </div>
                <span class="inline-flex items-center rounded-xl border border-slate-200 bg-slate-50 px-4 py-2 text-sm font-semibold text-slate-900 group-hover:bg-white">
                    <?= htmlspecialchars(t('common.open')) ?>
                </span>
            </div>
        </a>

        <a href="/nyakinama/admin/reports.php?year=<?= urlencode((string)$year) ?>"
           class="group rounded-3xl border border-slate-200 bg-white p-6 hover:border-slate-300 hover:shadow-sm hover:shadow-slate-900/5">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold text-slate-900"><?= htmlspecialchars(t('planning.card_debts_receivables')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('planning.card_debts_receivables_desc')) ?></div>
                </div>
                <span class="inline-flex items-center rounded-xl border border-slate-200 bg-slate-50 px-4 py-2 text-sm font-semibold text-slate-900 group-hover:bg-white">
                    <?= htmlspecialchars(t('common.open')) ?>
                </span>
            </div>
        </a>
    </div>
<?php endif; ?>

<?php
admin_footer();
