<?php
require_once __DIR__ . '/includes/admin_layout.php';

admin_header(t('admin.dashboard'));
$year = $_GET['year'] ?? '2024-2025';
?>
<div class="grid grid-cols-1 xl:grid-cols-12 gap-6">
    <section class="xl:col-span-8">
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-4">
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.total_budget')) ?></div>
                <div class="mt-2 text-2xl font-bold">42,155,213</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.year')) ?>: <?= htmlspecialchars($year) ?></div>
            </div>
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.total_receipts')) ?></div>
                <div class="mt-2 text-2xl font-bold">39,857,670</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('receipts.planned_vs_actual')) ?></div>
            </div>
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.total_expenses')) ?></div>
                <div class="mt-2 text-2xl font-bold">39,167,939</div>
                <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.by_categories')) ?></div>
            </div>
            <div class="rounded-2xl border border-slate-200 bg-white p-5">
                <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.remaining_balance')) ?></div>
                <div class="mt-2 text-2xl font-bold text-emerald-700">689,731</div>
                <div class="mt-1 text-xs text-slate-500">Result (A1+B1) - (A2+B2+C2)</div>
            </div>
        </div>

        <div class="mt-6 rounded-3xl border border-slate-200 bg-white p-6">
            <div class="flex items-start justify-between gap-4">
                <div>
                    <div class="text-sm font-semibold"><?= htmlspecialchars(t('admin.quick_actions')) ?></div>
                    <div class="mt-1 text-xs text-slate-500"><?= htmlspecialchars(t('admin.quick_actions_note')) ?></div>
                </div>
            </div>

            <div class="mt-5 grid grid-cols-1 md:grid-cols-2 gap-3">
                <a href="/nyakinama/admin/receipts.php?year=<?= urlencode($year) ?>" class="rounded-2xl border border-slate-200 bg-slate-50 px-5 py-4 hover:bg-slate-100">
                    <div class="text-sm font-bold"><?= htmlspecialchars(t('admin.add_receipt')) ?></div>
                    <div class="mt-1 text-xs text-slate-600"><?= htmlspecialchars(t('admin.add_receipt_desc')) ?></div>
                </a>
                <a href="/nyakinama/admin/expenses.php?year=<?= urlencode($year) ?>" class="rounded-2xl border border-slate-200 bg-slate-50 px-5 py-4 hover:bg-slate-100">
                    <div class="text-sm font-bold"><?= htmlspecialchars(t('admin.record_expense')) ?></div>
                    <div class="mt-1 text-xs text-slate-600"><?= htmlspecialchars(t('admin.record_expense_desc')) ?></div>
                </a>
                <a href="/nyakinama/admin/reports.php?year=<?= urlencode($year) ?>" class="rounded-2xl border border-slate-200 bg-slate-50 px-5 py-4 hover:bg-slate-100">
                    <div class="text-sm font-bold"><?= htmlspecialchars(t('admin.generate_reports')) ?></div>
                    <div class="mt-1 text-xs text-slate-600"><?= htmlspecialchars(t('admin.generate_reports_desc')) ?></div>
                </a>
                <a href="/nyakinama/admin/planning.php?year=<?= urlencode($year) ?>" class="rounded-2xl border border-slate-200 bg-slate-50 px-5 py-4 hover:bg-slate-100">
                    <div class="text-sm font-bold"><?= htmlspecialchars(t('admin.edit_planning')) ?></div>
                    <div class="mt-1 text-xs text-slate-600"><?= htmlspecialchars(t('admin.edit_planning_desc')) ?></div>
                </a>
            </div>
        </div>
    </section>

    <aside class="xl:col-span-4">
        <div class="rounded-3xl border border-slate-200 bg-white p-6">
            <div class="text-sm font-semibold"><?= htmlspecialchars(t('admin.status')) ?></div>
            <div class="mt-4 space-y-3 text-sm">
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.treasury')) ?></div>
                    <div class="mt-1 font-bold">689,731</div>
                    <div class="mt-1 text-xs text-slate-600"><?= htmlspecialchars(t('admin.banks_cash')) ?></div>
                </div>
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.receivables')) ?></div>
                    <div class="mt-1 font-bold">1,368,200</div>
                </div>
                <div class="rounded-2xl border border-slate-200 bg-slate-50 p-4">
                    <div class="text-xs font-semibold text-slate-500"><?= htmlspecialchars(t('admin.debts')) ?></div>
                    <div class="mt-1 font-bold">4,634,320</div>
                </div>
            </div>
        </div>
    </aside>
</div>
<?php
admin_footer();
